package centrocommerciale;

/**
 * Riceve i singoli parametri dalla CommercialFactory e colcola il singolo
 * guadagno (qui viene anche considerato il costo del 60% per le vendite)
 * 
 * @author koelio
 * @parameter earnings guadagni singoli per l'Attività
 * 
 */
public class Business extends Commercial{
	
	double earnings;
	double fixedcosts;
	double mqPrice;
	
	public Business(String id, String type, int localNumb, int mqTot,int costs,  int income) {
		super(id, type, localNumb, mqTot, income);
		
		double netIncome = (0.6 * income);
		if (mqTot >= 140) {
			mqPrice = mqTot * 7 + mqTot * 8;
		} else {
			mqPrice = mqTot * 16;
		}

		this.earnings = income - (netIncome + mqPrice + costs);

		System.out.println(id + " " + earnings);
		
	}
	
	@Override
	public double getEarnings() {

		return earnings;
	}

}
